DROP TRIGGER ADRMGT.RELEASE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADRMGT.RELEASE_AUDIR_TRGR
after Update or Delete or Insert
ON ADRMGT.RELEASE for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into RELEASE_H
		(
		RELEASE_H_ID,
		RELEASE_ID ,
                DEPLOYMENT_ID ,
                OWNING_APP_NAME,
                RELEASE_NUMBER,
                DESCRIPTION,
                PACKAGE_NAME,
                STATUS_NAME,
                DEPLOYMENT_NOTE,
                RECORD_MODIFIED_DATE,
                RECORD_MODIFIED_COUNT,
                RECORD_MODIFIED_BY,
                RECORD_CREATED_DATE,
                RECORD_CREATED_BY,
                HISTORY_CREATED_DATE,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		RELEASE_H_S.nextval,
		:old.RELEASE_ID,
                :old.DEPLOYMENT_ID,
		:old.OWNING_APP_NAME,
                :old.RELEASE_NUMBER,
                :old.DESCRIPTION,
                :old.PACKAGE_NAME,
		:old.STATUS_NAME,
		:old.DEPLOYMENT_NOTE,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
                :old.RECORD_MODIFIED_BY,
                :old.RECORD_CREATED_DATE,
                :old.RECORD_CREATED_BY,
                SYSDATE,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into RELEASE_H
        (
                RELEASE_H_ID,
		RELEASE_ID ,
                DEPLOYMENT_ID ,
                OWNING_APP_NAME,
                RELEASE_NUMBER,
                DESCRIPTION,
                PACKAGE_NAME,
                STATUS_NAME,
                DEPLOYMENT_NOTE,
                RECORD_MODIFIED_DATE,
                RECORD_MODIFIED_COUNT,
                RECORD_MODIFIED_BY,
                RECORD_CREATED_DATE,
                RECORD_CREATED_BY,
                HISTORY_CREATED_DATE,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		RELEASE_H_S.nextval,
		:new.RELEASE_ID,
                :new.DEPLOYMENT_ID,
		:new.OWNING_APP_NAME,
                :new.RELEASE_NUMBER,
                :new.DESCRIPTION,
                :new.PACKAGE_NAME,
		:new.STATUS_NAME,
		:new.DEPLOYMENT_NOTE,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
                :new.RECORD_MODIFIED_BY,
                :new.RECORD_CREATED_DATE,
                :new.RECORD_CREATED_BY,
                SYSDATE,
		mDML
		);

	end if;
end RELEASE_audir_trgr;
/
DROP TRIGGER ADRMGT.DEPLOYMENT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADRMGT.DEPLOYMENT_AUDIR_TRGR
after Update or Delete or Insert
ON ADRMGT.DEPLOYMENT for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into DEPLOYMENT_H
		(
		DEPLOYMENT_H_ID,
		DEPLOYMENT_ID ,
                TICKET_NUMBER ,
                DESCRIPTION,
                STATUS_NAME,
                DEPLOYMENT_NOTE,
                RECORD_MODIFIED_DATE,
                RECORD_MODIFIED_COUNT,
                RECORD_MODIFIED_BY,
                RECORD_CREATED_DATE,
                RECORD_CREATED_BY,
                HISTORY_CREATED_DATE,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		DEPLOYMENT_H_S.nextval,
		:old.DEPLOYMENT_ID,
		:old.TICKET_NUMBER,
                :old.DESCRIPTION,
		:old.STATUS_NAME,
		:old.DEPLOYMENT_NOTE,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
                :old.RECORD_MODIFIED_BY,
                :old.RECORD_CREATED_DATE,
                :old.RECORD_CREATED_BY,
                SYSDATE,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into DEPLOYMENT_H
        (
                DEPLOYMENT_H_ID,
		DEPLOYMENT_ID ,
                TICKET_NUMBER ,
                DESCRIPTION,
                STATUS_NAME,
                DEPLOYMENT_NOTE,
                RECORD_MODIFIED_DATE,
                RECORD_MODIFIED_COUNT,
                RECORD_MODIFIED_BY,
                RECORD_CREATED_DATE,
                RECORD_CREATED_BY,
                HISTORY_CREATED_DATE,
		TRANSACTION_TYPE_CODE
        )
		values
		(
		DEPLOYMENT_H_S.nextval,
                :new.DEPLOYMENT_ID,
		:new.TICKET_NUMBER,
                :new.DESCRIPTION,
		:new.STATUS_NAME,
		:new.DEPLOYMENT_NOTE,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
                :new.RECORD_MODIFIED_BY,
                :new.RECORD_CREATED_DATE,
                :new.RECORD_CREATED_BY,
                SYSDATE,
		mDML
		);

	end if;
end DEPLOYMENT_audir_trgr;
/
DROP TRIGGER ADRMGT.CCR_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADRMGT.CCR_AUDIR_TRGR
after Update or Delete or Insert
ON ADRMGT.CCR for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CCR_H
		(
		CCR_H_ID,
		CCR_ID ,
                DEPLOYMENT_ID,
                RELEASE_ID,
                SCHEMA_NAME ,
                CCR_NUMBER ,
                HEADLINE_TEXT,
                CR_NUMBER,
                PACKAGE_NAME,
                DEPLOYMENT_NOTE,
                RECORD_MODIFIED_DATE,
                RECORD_MODIFIED_COUNT,
                RECORD_MODIFIED_BY,
                RECORD_CREATED_DATE,
                RECORD_CREATED_BY,
                HISTORY_CREATED_DATE,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CCR_H_S.nextval,
		:old.CCR_ID,
		:old.DEPLOYMENT_ID,
        :old.RELEASE_ID,
		:old.SCHEMA_NAME,
		:old.CCR_NUMBER,
                :old.HEADLINE_TEXT,
		:old.CR_NUMBER,
                :old.PACKAGE_NAME,
		:old.DEPLOYMENT_NOTE,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
                :old.RECORD_MODIFIED_BY,
                :old.RECORD_CREATED_DATE,
                :old.RECORD_CREATED_BY,
                SYSDATE,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CCR_H
        (
        CCR_H_ID,
		CCR_ID ,
                DEPLOYMENT_ID,
                RELEASE_ID,
                SCHEMA_NAME ,
                CCR_NUMBER ,
                HEADLINE_TEXT,
                CR_NUMBER,
                PACKAGE_NAME,
                DEPLOYMENT_NOTE,
                RECORD_MODIFIED_DATE,
                RECORD_MODIFIED_COUNT,
                RECORD_MODIFIED_BY,
                RECORD_CREATED_DATE,
                RECORD_CREATED_BY,
                HISTORY_CREATED_DATE,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CCR_H_S.nextval,
		:new.CCR_ID,
		:new.DEPLOYMENT_ID,
        :new.RELEASE_ID,
		:new.SCHEMA_NAME,
		:new.CCR_NUMBER,
                :new.HEADLINE_TEXT,
		:new.CR_NUMBER,
                :new.PACKAGE_NAME,
		:new.DEPLOYMENT_NOTE,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
                :new.RECORD_MODIFIED_BY,
                :new.RECORD_CREATED_DATE,
                :new.RECORD_CREATED_BY,
                SYSDATE,
		mDML
		);

	end if;
end CCR_audir_trgr;
/
DROP TRIGGER ADRMGT.ADR_USER_CONTACT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADRMGT.ADR_USER_CONTACT_AUDIR_TRGR
after Update or Delete or Insert
ON ADRMGT.ADR_USER_CONTACT for each row
declare
       mDML char(1);
begin

    mDML := 'D';
    if DELETING then
        insert into ADRMGT.ADR_USER_CONTACT_H
        (
        ADR_USER_CONTACT_H_ID,
        ADR_USER_CONTACT_ID,
        EMAIL_ADDRESS_LIST,
        PROJECT_NAME,
        CONTACT_EMPLOYER,
        CONTACT_EMAIL_USER_NAME,
        CONTACT_LAST_NAME,
        CONTACT_FIRST_NAME,
        REQUESTOR_LAST_NAME,
        REQUESTOR_FIRST_NAME,
        APPROVER_LAST_NAME,
        APPROVER_FIRST_NAME,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        ADR_USER_CONTACT_H_s.nextval,
        :old.ADR_USER_CONTACT_ID,
        :old.EMAIL_ADDRESS_LIST,
        :old.PROJECT_NAME,
        :old.CONTACT_EMPLOYER,
        :old.CONTACT_EMAIL_USER_NAME,
        :old.CONTACT_LAST_NAME,
        :old.CONTACT_FIRST_NAME,
        :old.REQUESTOR_LAST_NAME,
        :old.REQUESTOR_FIRST_NAME,
        :old.APPROVER_LAST_NAME,
        :old.APPROVER_FIRST_NAME,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;
        insert into ADRMGT.ADR_USER_CONTACT_H
        (
        ADR_USER_CONTACT_H_ID,
        ADR_USER_CONTACT_ID,
        EMAIL_ADDRESS_LIST,
        PROJECT_NAME,
        CONTACT_EMPLOYER,
        CONTACT_EMAIL_USER_NAME,
        CONTACT_LAST_NAME,
        CONTACT_FIRST_NAME,
        REQUESTOR_LAST_NAME,
        REQUESTOR_FIRST_NAME,
        APPROVER_LAST_NAME,
        APPROVER_FIRST_NAME,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        ADR_USER_CONTACT_H_s.nextval,
        :new.ADR_USER_CONTACT_ID,
        :new.EMAIL_ADDRESS_LIST,
        :new.PROJECT_NAME,
        :new.CONTACT_EMPLOYER,
        :new.CONTACT_EMAIL_USER_NAME,
        :new.CONTACT_LAST_NAME,
        :new.CONTACT_FIRST_NAME,
        :new.REQUESTOR_LAST_NAME,
        :new.REQUESTOR_FIRST_NAME,
        :new.APPROVER_LAST_NAME,
        :new.APPROVER_FIRST_NAME,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end ADR_USER_CONTACT_audir_trgr;
/
DROP TRIGGER ADRMGT.ADR_PARAMETER_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADRMGT.ADR_PARAMETER_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADRMGT.ADR_PARAMETER
  FOR EACH ROW
DECLARE

    mDML   CHAR (1);

  BEGIN

    IF DELETING THEN

      INSERT
      INTO      ADRMGT.ADR_PARAMETER_H
                (Adr_parameter_h_id,
                 Transaction_type_code,
                 Adr_parameter_id,
                 Type,
                 Unit,
                 Application_name,
                 Parameter_name,
                 description,
                 Value,
                 Data_length,
                 Format_mask,
                 Inactive_flag,
                 Record_created_by,
                 Record_created_date,
                 Record_modified_by,
                 Record_modified_date,
                 Record_modified_count,
                 History_created_date)
      VALUES    (ADRMGT.Adr_Parameter_H_Id_S.NEXTVAL,
                 'D',
                 :OLD.Adr_parameter_id,
                 :OLD.Type,
                 :OLD.Unit,
                 :OLD.Application_name,
                 :OLD.Parameter_name,
                 :OLD.Description,
                 :OLD.Value,
                 :OLD.Data_length,
                 :OLD.Format_mask,
                 :OLD.Inactive_flag,
                 :OLD.Record_created_by,
                 :OLD.Record_created_date,
                 :OLD.Record_modified_by,
                 :OLD.Record_modified_date,
                 :OLD.Record_modified_count,
                 SYSDATE);

    ELSE

      IF UPDATING THEN

         mDML := 'U';

      ELSE

         mDML := 'I';

      END IF;

      INSERT
      INTO      ADRMGT.ADR_PARAMETER_H
                (Adr_parameter_h_id,
                 Transaction_type_code,
                 Adr_parameter_id,
                 Type,
                 Unit,
                 Application_name,
                 Parameter_name,
                 Description,
                 Value,
                 Data_length,
                 Format_mask,
                 Inactive_flag,
                 Record_created_by,
                 Record_created_date,
                 Record_modified_by,
                 Record_modified_date,
                 Record_modified_count,
                 History_created_date)
      VALUES    (ADRMGT.Adr_Parameter_H_Id_S.NEXTVAL,
                 mDML,
                 :NEW.Adr_parameter_id,
                 :NEW.type,
                 :NEW.unit,
                 :NEW.Application_name,
                 :NEW.Parameter_name,
                 :NEW.description,
                 :NEW.value,
                 :NEW.data_length,
                 :NEW.format_mask,
                 :NEW.Inactive_flag,
                 :NEW.Record_created_by,
                 :NEW.Record_created_date,
                 :NEW.Record_modified_by,
                 :NEW.Record_modified_date,
                 :NEW.Record_modified_count,
                 SYSDATE);

    END IF;

END Parameter_Audir_Trgr;
/
